import joblib
from keras.preprocessing import image
import numpy as np
import os.path
import cv2
from django.conf import settings


class classifier:
    def __init__(self):
        #Dataset 1 predictive models
        self.model =  joblib.load(settings.ROOT_PATH+ "ml/cnn_model.joblib")

    def predict(self, f):
        f = os.path.abspath(os.path.dirname(__file__))+ '/static/images/'+f
        img = image.load_img(f, grayscale=True, target_size=(48, 48))
        x = image.img_to_array(img)
        x = np.expand_dims(x, axis = 0)
        x /= 255

        custom = self.model.predict(x)
        print(custom[0])
        return self.get_emotion((custom[0]))

    def get_label(self, obj):
        signs = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z']
        print("Predicted Sign : ", signs[np.argmax(obj)])
        print("Probability Of Sign :",np.max(obj))
        return [signs[np.argmax(obj)],np.max(obj)]

    def predict(self, f):
        f = os.path.abspath(os.path.dirname(__file__))+ '/static/images/'+f
        img = image.load_img(f, color_mode = "grayscale", target_size=(28, 28))
        x = image.img_to_array(img)
        x = np.expand_dims(x, axis = 0)
        x /= 255
        custom = self.model.predict(x)
        return self.get_label(custom[0])
    